/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.column;

import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;

public final class Gatherer {
    private final IAggregator[] m_aggregator;

    public Gatherer(IAggregator[] aggregators) {
        this.m_aggregator = aggregators;
    }

    public void addIndexMapped(int[] mapping, Object[] values) {
        int n = 0;
        while (n < this.m_aggregator.length) {
            int index = mapping[n];
            if (index != -1) {
                try {
                    Object value = values[index];
                    if (value instanceof Number) {
                        this.m_aggregator[n].add(values[index]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n;
        }
    }

    public void add(Object[] values) {
        int n = 0;
        while (n < this.m_aggregator.length) {
            if (values[n] != null) {
                this.m_aggregator[n].add(values[n]);
            }
            ++n;
        }
    }

    public Object[] getValues() {
        Object[] result = new Object[this.m_aggregator.length];
        int n = 0;
        while (n < this.m_aggregator.length) {
            result[n] = this.m_aggregator[n].getResult();
            ++n;
        }
        return result;
    }

    public void add(RetriverHolder mapper, IEvent event) {
        IField[] retrivers = mapper.getRetrievers();
        int n = 0;
        while (n < this.m_aggregator.length) {
            if (retrivers[n] != null) {
                this.m_aggregator[n].add(retrivers[n].getValue(event));
            }
            ++n;
        }
    }

    public IAggregator[] getAggregators() {
        return this.m_aggregator;
    }
}

