/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.ui.components.graph.GraphEvents;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.ui.dnd.ClipboardManager;
import com.jrockit.mc.ui.misc.ErrorDialog;
import java.text.MessageFormat;
import org.eclipse.jface.action.Action;

public class StackTraceCopyAction
extends Action {
    private static final int MAX_CHARS_COUNT = 10000000;
    private final GraphEvents m_graphEvents;

    public StackTraceCopyAction(GraphEvents graphEvents, boolean single) {
        super(single ? Messages.THREAD_GRAPH_COMPONENT_COPY_STACKTRACE : Messages.THREAD_GRAPH_COMPONENT_COPY_STACKTRACES);
        this.m_graphEvents = graphEvents;
    }

    public void run() {
        StringBuilder allTraces = new StringBuilder();
        for (IEvent event : this.m_graphEvents) {
            StringBuilder trace = this.formatStackTrace(event);
            if (trace != null) {
                allTraces.append((CharSequence)trace);
            }
            if (allTraces.length() <= 10000000) continue;
            ErrorDialog.showError((String)Messages.THREAD_GRAPH_COMPONENT_CANNOT_COPY, (String)Messages.THREAD_GRAPH_COMPONENT_STACKTRACES_TOO_LARGE);
            return;
        }
        if (allTraces.length() > 0) {
            ClipboardManager.getDefault().setContents(allTraces.toString());
        }
    }

    private StringBuilder formatStackTrace(IEvent event) {
        Object value = event.getValue("(stackTrace)");
        if (value instanceof IMCStackTrace) {
            StringBuilder traceBuilder = new StringBuilder();
            traceBuilder.append(String.valueOf(event.getEventType().getName()) + "\n");
            IMCStackTrace s = (IMCStackTrace)value;
            if (s.getFrames() != null && s.getFrames().size() > 0) {
                for (IMCFrame frame : s.getFrames()) {
                    IMCMethod method = frame.getMethod();
                    Object[] values = new Object[]{method.getHumanReadable(false, false, true, true, true, false)};
                    String text = MessageFormat.format(Messages.THREAD_GRAPH_COMPONENT_TOOLTIP_STACK_TRACE_AT_TEXT, values);
                    traceBuilder.append(String.valueOf(text) + "\n");
                }
            }
            return traceBuilder;
        }
        return null;
    }
}

