/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.graph;

import com.jrockit.mc.common.util.CombinedIterator;
import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.ui.components.graph.EventGraphTree;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThread;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UIThreadGroup;
import com.jrockit.mc.flightrecorder.ui.components.graph.uimodel.UITrack;
import java.util.ArrayList;
import java.util.Iterator;

public final class ThreadEvents
implements Iterable<IEvent> {
    private final EventGraphTree m_tree;
    private final IEventFilter m_filter;
    private final ITimeRange m_timeRange;

    ThreadEvents(EventGraphTree tree, IEventFilter filter, ITimeRange tr) {
        this.m_tree = tree;
        this.m_filter = filter;
        this.m_timeRange = tr;
    }

    @Override
    public Iterator<IEvent> iterator() {
        ArrayList<Iterator<IEvent>> Iterators = new ArrayList<Iterator<IEvent>>();
        Object[] objectArray = this.m_tree.getSelectedData();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof UIThread) {
                Iterators.add(this.createIteratorFromThread((UIThread)o));
            }
            if (o instanceof UIThreadGroup) {
                Iterators.add(this.createIteratorFromThreadGroup((UIThreadGroup)o));
            }
            ++n2;
        }
        return new CombinedIterator(Iterators);
    }

    private Iterator<IEvent> createIteratorFromThreadGroup(UIThreadGroup group) {
        ArrayList<Iterator<IEvent>> iterators = new ArrayList<Iterator<IEvent>>();
        for (UIThread thread : group.getThreads()) {
            iterators.add(this.createIteratorFromThread(thread));
        }
        return new CombinedIterator(iterators);
    }

    private Iterator<IEvent> createIteratorFromThread(UIThread thread) {
        ArrayList<Iterator<IEvent>> iterators = new ArrayList<Iterator<IEvent>>();
        for (UITrack track : thread.getTracks()) {
            iterators.add(track.iterator(this.m_filter, this.m_timeRange, Expansion.NORMAL));
        }
        return new CombinedIterator(iterators);
    }
}

