/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.common.version.JavaVersionSupport;
import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.JVMSupportToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.services.ICommercialFeaturesService;
import com.jrockit.mc.rjmx.services.ServiceException;
import com.jrockit.mc.rjmx.services.ServiceNotAvailableException;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.EventTypeMetadata;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IEventTypeInfo;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IOptionDescriptor;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.internal.FLRRecordingInputStream;
import com.jrockit.mc.rjmx.services.flr.internal.FlightRecorderCommunicationHelper;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingDescriptorToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingOptionsToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingSettingsToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingTemplateToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.ValidationToolkit;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;

public class FlightRecorderService
implements IFlightRecorderService {
    static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx.flr");
    private final FlightRecorderCommunicationHelper helper;
    private long eventTypeMetaNextUpdate;
    private List<EventTypeMetadata> eventTypeMetas;
    private Map<Integer, EventTypeMetadata> eventTypeMetaByInt;
    private Map<EventTypeID, IEventTypeInfo> eventTypeInfoById;
    private final ICommercialFeaturesService cfs;
    private final IMBeanHelperService mbhs;
    private final String serverId;

    private boolean isDynamicFlightRecorderSupported(IConnectionHandle handle) {
        return ConnectionToolkit.isHotSpot(handle) && ConnectionToolkit.isJavaVersionAboveOrEqual(handle, JavaVersionSupport.DYNAMIC_JFR_SUPPORTED);
    }

    private boolean isFlightRecorderDisabled(IConnectionHandle handle) {
        if (this.cfs != null) {
            return !this.cfs.isCommercialFeaturesEnabled() || JVMSupportToolkit.isFlightRecorderDisabled(handle, false);
        }
        return true;
    }

    public FlightRecorderService(IConnectionHandle handle) throws ServiceException {
        this.cfs = handle.getServiceOrThrow(ICommercialFeaturesService.class);
        if (!this.isDynamicFlightRecorderSupported(handle) && this.isFlightRecorderDisabled(handle)) {
            throw new ServiceNotAvailableException();
        }
        if (JVMSupportToolkit.isFlightRecorderDisabled(handle, true)) {
            throw new ServiceNotAvailableException();
        }
        this.helper = new FlightRecorderCommunicationHelper(handle.getServiceOrThrow(MBeanServerConnection.class));
        this.mbhs = handle.getServiceOrThrow(IMBeanHelperService.class);
        this.serverId = handle.getServerDescriptor().getGUID();
    }

    @Override
    public void stop(IRecordingDescriptor descriptor) throws FlightRecorderException {
        this.stop(descriptor.getObjectName());
    }

    private void stop(ObjectName objectName) throws FlightRecorderException {
        try {
            this.helper.invokeOperation("stop", objectName);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not stop the recording!", e);
        }
    }

    @Override
    public void close(IRecordingDescriptor descriptor) throws FlightRecorderException {
        this.helper.closeRecording(descriptor);
    }

    @Override
    public IRecordingDescriptor start(Map<String, ?> recordingOptions, IEventSettingsHolder eventSettings) throws FlightRecorderException {
        try {
            this.validateOptions(recordingOptions);
            String name = RecordingOptionsToolkit.getName(recordingOptions);
            ObjectName recording = (ObjectName)this.helper.invokeOperation("createRecording", name);
            this.helper.invokeOperation("setRecordingOptions", recording, RecordingOptionsToolkit.getRecordingOptions(recordingOptions));
            if (eventSettings != null) {
                this.updateEventSettings(recording, eventSettings);
            }
            this.helper.invokeOperation("start", recording);
            for (IRecordingDescriptor descriptor : this.getAvailableRecordings()) {
                if (!recording.equals(descriptor.getObjectName())) continue;
                return descriptor;
            }
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not start the recording!", e);
        }
        return null;
    }

    @Override
    public Map<String, IConvertibleValue<?>> getRecordingOptions(IRecordingDescriptor recording) throws FlightRecorderException {
        try {
            return this.getRecordingDescriptor(recording.getObjectName());
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not retrieve recording options.", e);
        }
    }

    private Map<String, IConvertibleValue<?>> getRecordingDescriptor(ObjectName name) throws FlightRecorderException, IOException {
        return RecordingOptionsToolkit.getRecordingOptions((CompositeData)this.helper.invokeOperation("getRecordingOptions", name));
    }

    @Override
    public IEventSettingsHolder getEventSettings(IRecordingDescriptor recording) throws FlightRecorderException {
        try {
            Map<Integer, EventTypeMetadata> map = this.getEventTypeByIntMap();
            List compositeList = (List)this.helper.invokeOperation("getEventSettings", recording.getObjectName());
            return RecordingSettingsToolkit.fromCompositeData(map, compositeList);
        }
        catch (Exception e) {
            FlightRecorderException flr = new FlightRecorderException("Could not retrieve recording options for recording " + recording.getName() + '.');
            flr.initCause(e);
            throw flr;
        }
    }

    @Override
    public Map<String, IOptionDescriptor> getAvailableRecordingOptions() throws FlightRecorderException {
        return RecordingOptionsToolkit.getAvailableRecordingOptions();
    }

    public String toString() {
        return this.helper.toString();
    }

    @Override
    public InputStream openStream(IRecordingDescriptor descriptor, boolean removeOnClose) throws FlightRecorderException {
        IRecordingDescriptor streamDescriptor = descriptor;
        boolean clone = this.isStillRunning(descriptor);
        if (clone) {
            streamDescriptor = this.clone(descriptor);
        }
        return new FLRRecordingInputStream(this.helper, streamDescriptor, clone | removeOnClose);
    }

    @Override
    public InputStream openStream(IRecordingDescriptor descriptor, Date startTime, Date endTime, boolean removeOnClose) throws FlightRecorderException {
        IRecordingDescriptor streamDescriptor = descriptor;
        boolean clone = this.isStillRunning(descriptor);
        if (clone) {
            streamDescriptor = this.clone(descriptor);
        }
        return new FLRRecordingInputStream(this.helper, streamDescriptor, startTime, endTime, clone | removeOnClose);
    }

    @Override
    public Collection<EventTypeMetadata> getAvailableEventTypes() throws FlightRecorderException {
        return this.updateEventTypeMetadataMaps(true);
    }

    @Override
    public List<IRecordingDescriptor> getAvailableRecordings() throws FlightRecorderException {
        List attribute = (List)this.helper.getAttribute("Recordings");
        ArrayList<IRecordingDescriptor> recordings = new ArrayList<IRecordingDescriptor>();
        for (CompositeData data : attribute) {
            recordings.add(RecordingDescriptorToolkit.createRecordingDescriptor(this.serverId, data));
        }
        return Collections.unmodifiableList(recordings);
    }

    @Override
    public IEventSettingsHolder getCurrentEventTypeSettings() throws FlightRecorderException {
        Map<Integer, EventTypeMetadata> byIntMap = this.getEventTypeByIntMap();
        List compositeList = (List)this.helper.getAttribute("EventSettings");
        return RecordingSettingsToolkit.fromCompositeData(byIntMap, compositeList);
    }

    @Override
    public IRecordingDescriptor getUpdatedRecordingDescription(IRecordingDescriptor descriptor) throws FlightRecorderException {
        return this.getUpdatedRecordingDescriptor(descriptor.getObjectName());
    }

    @Override
    public List<String> getServerTemplates() throws FlightRecorderException {
        List compositeData = (List)this.helper.getAttribute("AvailablePresets");
        return RecordingTemplateToolkit.getServerTemplates(compositeData);
    }

    @Override
    public void updateEventSettings(IRecordingDescriptor descriptor, IEventSettingsHolder settings) throws FlightRecorderException {
        try {
            this.updateEventSettings(descriptor.getObjectName(), settings);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed updating the recording settings for " + descriptor.getName(), e);
        }
    }

    private IRecordingDescriptor getUpdatedRecordingDescriptor(ObjectName name) throws FlightRecorderException {
        return RecordingDescriptorToolkit.getRecordingByDescriptor(name, this.getAvailableRecordings());
    }

    private void validateOptions(Map<String, ?> recordingOptions) throws FlightRecorderException {
        try {
            ValidationToolkit.validate(recordingOptions);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not validate options!\n" + e.getMessage());
        }
    }

    @Override
    public Map<EventTypeID, IEventTypeInfo> getEventTypeInfoMapByID() throws FlightRecorderException {
        this.updateEventTypeMetadataMaps(false);
        return this.eventTypeInfoById;
    }

    private Map<Integer, EventTypeMetadata> getEventTypeByIntMap() throws FlightRecorderException {
        this.updateEventTypeMetadataMaps(false);
        return this.eventTypeMetaByInt;
    }

    private Collection<EventTypeMetadata> updateEventTypeMetadataMaps(boolean force) throws FlightRecorderException {
        long timeStamp = System.currentTimeMillis();
        if (force || timeStamp > this.eventTypeMetaNextUpdate) {
            List compositeList = (List)this.helper.getAttribute("EventDescriptors");
            ArrayList<EventTypeMetadata> metaDataList = new ArrayList<EventTypeMetadata>(compositeList.size());
            HashMap<Integer, EventTypeMetadata> byInt = new HashMap<Integer, EventTypeMetadata>();
            HashMap<EventTypeID, EventTypeMetadata> byId = new HashMap<EventTypeID, EventTypeMetadata>();
            for (CompositeData data : compositeList) {
                try {
                    EventTypeMetadata element = RecordingSettingsToolkit.fromCompositeData(data);
                    metaDataList.add(element);
                    byInt.put(element.getId(), element);
                    byId.put(element.getEventTypeID(), element);
                }
                catch (URISyntaxException e) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not create event metadata for composite data!", e);
                }
            }
            this.eventTypeMetaNextUpdate = timeStamp + 60000L;
            this.eventTypeMetas = Collections.unmodifiableList(metaDataList);
            this.eventTypeMetaByInt = Collections.unmodifiableMap(byInt);
            this.eventTypeInfoById = Collections.unmodifiableMap(byId);
        }
        return this.eventTypeMetas;
    }

    private boolean isStillRunning(IRecordingDescriptor descriptor) throws FlightRecorderException {
        IRecordingDescriptor updatedDescriptor = this.getUpdatedRecordingDescription(descriptor);
        return updatedDescriptor != null && IRecordingDescriptor.RecordingState.RUNNING.equals((Object)updatedDescriptor.getState());
    }

    private IRecordingDescriptor clone(IRecordingDescriptor descriptor) throws FlightRecorderException {
        try {
            ObjectName name = (ObjectName)this.helper.invokeOperation("cloneRecording", descriptor.getObjectName(), "Clone of " + descriptor.getName(), Boolean.TRUE);
            return this.getUpdatedRecordingDescriptor(name);
        }
        catch (IOException e) {
            throw new FlightRecorderException("Could not clone the " + descriptor.getName() + " recording ", e);
        }
    }

    private void updateEventSettings(ObjectName recording, IEventSettingsHolder eventSettings) throws OpenDataException, IOException, FlightRecorderException {
        this.helper.invokeOperation("updateEventSettings", recording, RecordingSettingsToolkit.toCompositeData(this.getAvailableEventTypes(), eventSettings));
    }

    @Override
    public void updateRecordingOptions(IRecordingDescriptor descriptor, Map<String, ?> options) throws FlightRecorderException {
        this.validateOptions(options);
        try {
            this.helper.invokeOperation("setRecordingOptions", descriptor.getObjectName(), RecordingOptionsToolkit.getRecordingOptions(options));
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed updating the recording options for " + descriptor.getName(), e);
        }
    }

    @Override
    public InputStream openStream(IRecordingDescriptor descriptor, long time, boolean removeOnClose) throws FlightRecorderException {
        long serverTime = this.mbhs.getApproximateServerTime(System.currentTimeMillis());
        Date startDate = new Date(serverTime - time);
        Date endDate = new Date(serverTime);
        return this.openStream(descriptor, startDate, endDate, removeOnClose);
    }

    @Override
    public boolean isEnabled() {
        return this.cfs.isCommercialFeaturesEnabled();
    }

    @Override
    public void enable() throws FlightRecorderException {
        try {
            this.cfs.enableCommercialFeatures();
        }
        catch (Exception e) {
            throw new FlightRecorderException("Failed to enable commercial features", e);
        }
    }
}

