/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.internal.AbstractNotificationConstraint;
import com.jrockit.mc.rjmx.triggers.internal.TimeEntry;
import java.util.Date;
import org.w3c.dom.Element;

public final class NotificationConstraintTimeRange
extends AbstractNotificationConstraint
implements IDescribable {
    private static final String XML_ELEMENT_TIME_FROM = "time_from";
    private static final String XML_ELEMENT_TIME_TO = "time_to";
    public static final String NAME = "Time span";
    public static final String DESCRIPTION = "A constraint that allows notification only if the issue time of the event was within the time boundary (inclusive).";
    private TimeEntry m_timeFrom;
    private TimeEntry m_timeTo;

    public NotificationConstraintTimeRange() {
        this(7, 0, 18, 0);
    }

    public NotificationConstraintTimeRange(Date from, Date to) {
        this.m_timeFrom = new TimeEntry(from);
        this.m_timeTo = new TimeEntry(to);
    }

    public NotificationConstraintTimeRange(int fromHour, int fromMinutes, int toHour, int toMinutes) {
        this.m_timeFrom = new TimeEntry(fromHour, fromMinutes);
        this.m_timeTo = new TimeEntry(toHour, toMinutes);
    }

    @Override
    public boolean isValid(TriggerEvent e) {
        return this.validateTime(e.getCreationTime());
    }

    private boolean validateTime(Date validationDate) {
        TimeEntry now = new TimeEntry(validationDate);
        return this.getTimeFrom().beforeOrEquals(this.getTimeTo()) ? now.afterOrEquals(this.getTimeFrom()) && now.beforeOrEquals(this.getTimeTo()) : now.afterOrEquals(this.getTimeFrom()) || now.beforeOrEquals(this.getTimeTo());
    }

    public TimeEntry getTimeFrom() {
        return this.m_timeFrom;
    }

    public void setTimeFrom(TimeEntry timeFrom) {
        this.m_timeFrom = timeFrom;
    }

    public TimeEntry getTimeTo() {
        return this.m_timeTo;
    }

    public void setTimeTo(TimeEntry timeTo) {
        this.m_timeTo = timeTo;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public String getExtendedInfo() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(" From = ");
        buf.append(this.getTimeFrom());
        buf.append(" To = ");
        buf.append(this.getTimeTo());
        return buf.toString();
    }

    @Override
    public void initializeFromXml(Element node) {
        String fromTime = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_TIME_FROM, null);
        String toTime = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_TIME_TO, null);
        this.setTimeFrom(new TimeEntry(fromTime));
        this.setTimeTo(new TimeEntry(toTime));
    }

    @Override
    public void exportToXml(Element constraintNode) {
        XmlToolkit.setSetting((Element)constraintNode, (String)XML_ELEMENT_TIME_FROM, (String)this.getTimeFrom().toString());
        XmlToolkit.setSetting((Element)constraintNode, (String)XML_ELEMENT_TIME_TO, (String)this.getTimeTo().toString());
    }
}

