/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.JByteField;
import sun.jvm.hotspot.types.JIntField;
import sun.jvm.hotspot.types.JLongField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class PerfDataPrologue
extends VMObject {
    private static JIntField magicField;
    private static JByteField byteOrderField;
    private static JByteField majorVersionField;
    private static JByteField minorVersionField;
    private static JByteField accessibleField;
    private static JIntField usedField;
    private static JIntField overflowField;
    private static JLongField modTimeStampField;
    private static JIntField entryOffsetField;
    private static JIntField numEntriesField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("PerfDataPrologue");
        magicField = type.getJIntField("magic");
        byteOrderField = type.getJByteField("byte_order");
        majorVersionField = type.getJByteField("major_version");
        minorVersionField = type.getJByteField("minor_version");
        accessibleField = type.getJByteField("accessible");
        usedField = type.getJIntField("used");
        overflowField = type.getJIntField("overflow");
        modTimeStampField = type.getJLongField("mod_time_stamp");
        entryOffsetField = type.getJIntField("entry_offset");
        numEntriesField = type.getJIntField("num_entries");
    }

    public PerfDataPrologue(Address addr) {
        super(addr);
    }

    public int magic() {
        return magicField.getValue(this.addr);
    }

    public byte byteOrder() {
        return byteOrderField.getValue(this.addr);
    }

    public byte majorVersion() {
        return majorVersionField.getValue(this.addr);
    }

    public boolean accessible() {
        return accessibleField.getValue(this.addr) != 0;
    }

    public int used() {
        return usedField.getValue(this.addr);
    }

    public int overflow() {
        return overflowField.getValue(this.addr);
    }

    public long modTimeStamp() {
        return modTimeStampField.getValue(this.addr);
    }

    public int entryOffset() {
        return entryOffsetField.getValue(this.addr);
    }

    public int numEntries() {
        return numEntriesField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                PerfDataPrologue.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

