/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui;

import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.common.IUserAction;
import com.jrockit.mc.common.debug.Debug;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.CloseRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.DumpLastPartRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.DumpRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.DumpWholeRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.EditRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.PrintRecordingDescriptorAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.actions.StopRecordingAction;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.actionprovider.IActionProvider;
import com.jrockit.mc.rjmx.actionprovider.IDoubleClickable;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.ui.misc.IGraphical;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class RecordingProvider
implements IActionProvider,
IDescribable,
IGraphical,
IDoubleClickable {
    private static final char INFINITY = '\u221e';
    private static final char DELAYED_CONTINUOUS = '\u2192';
    private static final char DELAYED_DURATION = '\u21e5';
    private long timeRemaining;
    private IRecordingDescriptor recordingDescriptor;
    private MCFile dumpToFile;
    private final IServerHandle serverHandle;
    private boolean wasClosed = false;
    private boolean isOpening;

    RecordingProvider(IServerHandle serverHandle, IRecordingDescriptor recording) {
        this.serverHandle = serverHandle;
        this.recordingDescriptor = recording;
        this.dumpToFile = ControlPanel.getDefaultRecordingFile(serverHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRecording(IRecordingDescriptor recording, IConnectionHandle connectionHandle) {
        long timeRemaining = RecordingProvider.calculateTimeRemaining(recording, connectionHandle);
        RecordingProvider recordingProvider = this;
        synchronized (recordingProvider) {
            this.recordingDescriptor = recording;
            this.timeRemaining = timeRemaining;
        }
    }

    private static long calculateTimeRemaining(IRecordingDescriptor recording, IConnectionHandle connectionHandle) {
        Date startTime = recording.getStartTime();
        long duration = recording.getDuration();
        if (startTime == null || duration < 0L) {
            return 0L;
        }
        long endTime = RecordingProvider.getServerTimeAsLocalTime(startTime.getTime() + duration, connectionHandle);
        return Math.max(endTime - System.currentTimeMillis(), 0L);
    }

    private static long getServerTimeAsLocalTime(long time, IConnectionHandle connectionHandle) {
        IMBeanHelperService service = (IMBeanHelperService)connectionHandle.getServiceOrNull(IMBeanHelperService.class);
        return service != null ? time - service.getApproximateServerTime(0L) : time;
    }

    public synchronized IRecordingDescriptor getRecordingDescriptor() {
        return this.recordingDescriptor;
    }

    public synchronized long getTimeRemaining() {
        return this.timeRemaining;
    }

    public IServerHandle getServerHandle() {
        return this.serverHandle;
    }

    public synchronized void setClosed() {
        this.wasClosed = true;
    }

    public synchronized boolean wasClosed() {
        return this.wasClosed;
    }

    public synchronized void setDumpToFile(MCFile dumpToFile) {
        this.dumpToFile = dumpToFile;
    }

    public synchronized MCFile getDumpToFile() {
        return this.dumpToFile;
    }

    public synchronized void setIsOpening(boolean isOpening) {
        this.isOpening = isOpening;
    }

    private synchronized boolean isOpening() {
        return this.isOpening;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.getRecordingDescriptor().getState() == IRecordingDescriptor.RecordingState.STOPPED || this.getRecordingDescriptor().getState() == IRecordingDescriptor.RecordingState.CREATED) {
            return ControlPanel.getDefault().getMCImageDescriptor("FLR_finished.gif");
        }
        return ControlPanel.getDefault().getMCImageDescriptor("FLR_on.gif");
    }

    public String getName() {
        IRecordingDescriptor rd = this.getRecordingDescriptor();
        if (rd.getState() == IRecordingDescriptor.RecordingState.RUNNING && rd.isContinuous()) {
            return String.valueOf(rd.getName()) + " (" + '\u221e' + ")";
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.STOPPED) {
            return String.valueOf(rd.getName()) + (this.isOpening() ? " (" + Messages.RECORDING_INFO_OPENING + ")" : "");
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.CREATED) {
            return String.valueOf(rd.getName()) + " (" + (rd.isContinuous() ? (char)'\u2192' : '\u21e5') + ")";
        }
        long timeRemaining = this.getTimeRemaining();
        return String.valueOf(rd.getName()) + (timeRemaining == 0L ? "" : " (" + TimeRangeToolkit.convertMillisToSecondsString((long)timeRemaining) + ")");
    }

    public String getDescription() {
        IRecordingDescriptor rd = this.getRecordingDescriptor();
        if (rd.getState() == IRecordingDescriptor.RecordingState.RUNNING && rd.isContinuous()) {
            return NLS.bind((String)Messages.RECORDING_INFO_CONTINUOUS, (Object)rd.getStartTime());
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.STOPPED) {
            return NLS.bind((String)Messages.RECORDING_INFO_STOPPED, (Object)TimeRangeToolkit.convertMillisToSecondsString((long)(rd.getDataEndTime().getTime() - rd.getDataStartTime().getTime())));
        }
        if (rd.getState() == IRecordingDescriptor.RecordingState.CREATED) {
            return rd.isContinuous() ? NLS.bind((String)Messages.RECORDING_INFO_CREATED_CONTINUOUS, (Object)rd.getStartTime()) : NLS.bind((String)Messages.RECORDING_INFO_CREATED_DURATION, (Object)rd.getStartTime(), (Object)TimeRangeToolkit.convertMillisToSecondsString((long)rd.getDuration()));
        }
        return NLS.bind((String)Messages.RECORDING_INFO_ONGOING, (Object)rd.getStartTime());
    }

    public boolean hasChildren() {
        return false;
    }

    public Collection<? extends IActionProvider> getChildren() {
        return Collections.emptyList();
    }

    public List<? extends IUserAction> getActions() {
        ArrayList<Object> actions = new ArrayList<Object>();
        if (this.isStarted()) {
            actions.add((Object)new DumpRecordingAction(this));
            actions.add((Object)new DumpWholeRecordingAction(this));
            actions.add((Object)new DumpLastPartRecordingAction(this));
        }
        if (this.isAlive()) {
            actions.add((Object)new EditRecordingAction(this));
            actions.add((Object)new StopRecordingAction(this));
        }
        if (Debug.isDebug()) {
            actions.add(new PrintRecordingDescriptorAction(this));
        }
        actions.add((Object)new CloseRecordingAction(this));
        return actions;
    }

    public IUserAction getDoubleClickAction() {
        if (!this.isStarted()) {
            return new EditRecordingAction(this);
        }
        if (FlightRecorderUI.getDefault().isSetLastPartToDump()) {
            return new DumpLastPartRecordingAction(this);
        }
        if (FlightRecorderUI.getDefault().isSetDumpWhole()) {
            return new DumpWholeRecordingAction(this);
        }
        return new DumpRecordingAction(this);
    }

    public boolean isAlive() {
        IRecordingDescriptor.RecordingState state = this.getRecordingDescriptor().getState();
        return state == IRecordingDescriptor.RecordingState.CREATED || state == IRecordingDescriptor.RecordingState.RUNNING;
    }

    private boolean isStarted() {
        IRecordingDescriptor.RecordingState state = this.getRecordingDescriptor().getState();
        return state == IRecordingDescriptor.RecordingState.RUNNING || state == IRecordingDescriptor.RecordingState.STOPPING || state == IRecordingDescriptor.RecordingState.STOPPED;
    }

    public boolean isStopped() {
        IRecordingDescriptor.RecordingState state = this.getRecordingDescriptor().getState();
        return state == IRecordingDescriptor.RecordingState.STOPPED;
    }
}

