/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.common.IMemberAccessor;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.ui.column.ColumnComposite;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.ui.dnd.ClipboardManager;
import com.jrockit.mc.ui.dnd.TableStringBuilder;
import com.jrockit.mc.ui.handlers.MCSelectionProviderAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public class CopyColumnsHandler
extends MCSelectionProviderAction {
    private final ColumnComposite columnComposite;

    public CopyColumnsHandler(ColumnComposite columnComposite) {
        super("org.eclipse.ui.edit.copy", (ISelectionProvider)columnComposite.getViewer());
        this.columnComposite = columnComposite;
    }

    public void run() {
        Iterable<IColumn> columns;
        ClipboardManager cbm = ClipboardManager.getDefault();
        TableStringBuilder stb = new TableStringBuilder(cbm.shouldCopyAsCsv());
        Iterable<IColumn> iterable = columns = cbm.shouldCopyOnlyVisible() ? this.columnComposite.getVisibleColumns() : this.columnComposite.getColumns();
        if (cbm.shouldCopyColumnHeaders()) {
            for (IColumn column : columns) {
                stb.appendCellHeader(column.getName(), null);
            }
            stb.appendNewLine();
        }
        boolean raw = cbm.shouldCopyAsRawData();
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection instanceof ITreeSelection) {
            TreePath[] treePathArray = ((ITreeSelection)selection).getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                for (IColumn column : columns) {
                    int indent = cbm.shouldIndentForStructure() ? path.getSegmentCount() - 1 : 0;
                    stb.appendCell(CopyColumnsHandler.formatObject(path.getLastSegment(), column, raw), indent);
                }
                stb.appendNewLine();
                ++n2;
            }
        } else {
            for (Object o : selection.toList()) {
                for (IColumn column : columns) {
                    stb.appendCell(CopyColumnsHandler.formatObject(o, column, raw), 0);
                }
                stb.appendNewLine();
            }
        }
        cbm.setContents(stb.toString());
    }

    private static String formatObject(Object o, IColumn column, boolean raw) {
        IMemberAccessor<?, Object> cellAccessor = column.getCellAccessor();
        if (raw && cellAccessor != null) {
            Object cell = cellAccessor.getMember(o);
            if (cell instanceof IQuantity) {
                return ((IQuantity)cell).persistableString();
            }
            return cell == null ? "" : TypeHandling.getValueString((Object)cell);
        }
        return column.getLabelProvider().getText(o);
    }
}

