/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class OverallocatedString
extends IteratingRule {
    private FieldAccess fldCount;
    private FieldAccess fldOffset;
    private FieldAccess fldValue;
    private JavaClass clsString;
    private Map<Instance, Integer> covered = new HashMap<Instance, Integer>();
    private int total;

    public OverallocatedString() {
        super(NbBundle.getMessage(OverallocatedString.class, (String)"LBL_OverStr_Name"), NbBundle.getMessage(OverallocatedString.class, (String)"LBL_OverStr_Desc"), "java.lang.String");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(OverallocatedString.class, (String)"LBL_OverStr_LongDesc");
    }

    @Override
    protected void perform(Instance instance) {
        int n = this.fldOffset.getIntValue(instance);
        int n2 = this.fldCount.getIntValue(instance);
        PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)this.fldValue.getRefValue(instance);
        if (primitiveArrayInstance == null) {
            return;
        }
        if (n > 0 || primitiveArrayInstance.getLength() > n2) {
            if (this.covered.containsKey(primitiveArrayInstance)) {
                this.total -= this.covered.remove(primitiveArrayInstance).intValue();
            } else {
                int n3 = 2 * n + 2 * (primitiveArrayInstance.getLength() - (n2 + n));
                this.covered.put((Instance)primitiveArrayInstance, n3);
                this.total += n3;
            }
        }
    }

    @Override
    protected void prepareRule(MemoryLint memoryLint) {
        Heap heap = memoryLint.getHeap();
        this.clsString = heap.getJavaClassByName("java.lang.String");
        this.fldOffset = new FieldAccess(this.clsString, "offset");
        this.fldCount = new FieldAccess(this.clsString, "count");
        this.fldValue = new FieldAccess(this.clsString, "value");
    }

    @Override
    protected void summary() {
        this.getContext().appendResults(NbBundle.getMessage(OverallocatedString.class, (String)"FMT_OverStr_Result", (Object)this.total));
        Histogram histogram = new Histogram();
        for (Map.Entry<Instance, Integer> entry : this.covered.entrySet()) {
            String string = this.getContext().getRootIncommingString(entry.getKey());
            string = Utils.printClass(this.getContext(), string);
            histogram.add(string, new Histogram.Entry(entry.getValue().intValue()));
        }
        this.getContext().appendResults(histogram.toString(5000));
    }
}

