/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.components.ui.settings.FieldInput;
import com.jrockit.mc.components.ui.settings.TextControl;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.TextNode;
import com.jrockit.mc.ui.model.fields.Field;
import java.text.ParseException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextNodeInput
extends FieldInput {
    private final String m_tooltip;
    private final TextNode m_textNode;

    public TextNodeInput(String key, String name, Field field, TextNode textNode, Object min, Object max, String tooltip) {
        super(key, name, field, (Object)textNode.getValue(), min, max);
        this.m_textNode = textNode;
        this.m_tooltip = tooltip;
    }

    public void create(Composite parent, int horizontalSpan) {
        this.create(parent, horizontalSpan, 0);
    }

    public void create(Composite parent, int horizontalSpan, int indent) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabelText());
        this.adaptLabel(indent, label);
        this.m_text = new TextControl(parent, 2048);
        this.adaptText(horizontalSpan);
    }

    public void create(Composite parent, int horizontalSpan, FormToolkit toolkit) {
        Label label = toolkit.createLabel(parent, this.getLabelText(), 0);
        this.adaptLabel(0, label);
        this.m_text = new TextControl(parent, this.getTextStyle(), toolkit);
        this.adaptText(horizontalSpan);
    }

    private String getLabelText() {
        return this.getName();
    }

    private int getTextStyle() {
        return 2050;
    }

    private void adaptText(int horizontalSpan) {
        GridData gdText = new GridData(4, 4, true, false);
        gdText.horizontalSpan = horizontalSpan - 1;
        this.m_text.getControl().setLayoutData((Object)gdText);
        String formattedDefaultValue = this.m_field.formatObject(this.m_defaultValue);
        this.m_text.setText(formattedDefaultValue);
        this.m_text.getControl().setToolTipText(this.m_tooltip);
        this.hookTextListener();
    }

    private GridData adaptLabel(int indent, Label label) {
        GridData gdLabel = new GridData(4, 0x1000000, false, false);
        gdLabel.horizontalIndent = indent;
        label.setLayoutData((Object)gdLabel);
        return gdLabel;
    }

    protected void storeTypedValue(String text) {
        this.m_lastTyped = text;
        try {
            Tokenizer t = new Tokenizer(text);
            Object o = this.m_field.parse(t);
            if (o != null && !t.hasNext()) {
                this.setPropertyValue(text);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected String getPropertyValue() {
        return this.m_textNode.getValue().toString();
    }

    protected void setPropertyValue(String value) {
        this.m_textNode.setValue(value);
    }

    public boolean isEnabled() {
        return this.m_textNode != null;
    }
}

