/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.uihandler.api.Deactivated;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EnabledModulesCollector
implements Deactivated {
    private List<ModuleInfo> previouslyEnabled = Collections.emptyList();
    private List<ModuleInfo> previouslyDisabled = Collections.emptyList();

    @Override
    public void deactivated(Logger logger) {
        Object[] objectArray;
        LogRecord logRecord;
        Object object2;
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
        ArrayList<ModuleInfo> arrayList2 = new ArrayList<ModuleInfo>();
        for (Object object2 : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            if (object2.isEnabled()) {
                arrayList.add((ModuleInfo)object2);
                continue;
            }
            arrayList2.add((ModuleInfo)object2);
        }
        ArrayList arrayList3 = new ArrayList(arrayList);
        arrayList3.removeAll(this.previouslyEnabled);
        object2 = new ArrayList(arrayList2);
        object2.removeAll(this.previouslyDisabled);
        if (!arrayList3.isEmpty()) {
            logRecord = new LogRecord(Level.CONFIG, "UI_ENABLED_MODULES");
            objectArray = EnabledModulesCollector.getModuleNames(arrayList3);
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(logger.getName());
            logRecord.setResourceBundle(NbBundle.getBundle(EnabledModulesCollector.class));
            logRecord.setResourceBundleName(EnabledModulesCollector.class.getPackage().getName() + ".Bundle");
            logger.log(logRecord);
        }
        if (!object2.isEmpty()) {
            logRecord = new LogRecord(Level.CONFIG, "UI_DISABLED_MODULES");
            objectArray = EnabledModulesCollector.getModuleNames((List<ModuleInfo>)object2);
            logRecord.setParameters(objectArray);
            logRecord.setLoggerName(logger.getName());
            logRecord.setResourceBundle(NbBundle.getBundle(EnabledModulesCollector.class));
            logRecord.setResourceBundleName(EnabledModulesCollector.class.getPackage().getName() + ".Bundle");
            logger.log(logRecord);
        }
        this.previouslyEnabled = arrayList;
        this.previouslyDisabled = arrayList2;
    }

    static String[] getModuleNames(List<ModuleInfo> list) {
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (ModuleInfo moduleInfo : list) {
            SpecificationVersion specificationVersion = moduleInfo.getSpecificationVersion();
            if (specificationVersion != null) {
                stringArray[n++] = moduleInfo.getCodeName() + " [" + specificationVersion.toString() + "]";
                continue;
            }
            stringArray[n++] = moduleInfo.getCodeName();
        }
        return stringArray;
    }

    private static List<String> getClusterNames() {
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            String[] stringArray = string.split(File.pathSeparator);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File(stringArray[i]);
                if (!file.exists()) continue;
                arrayList.add(file.getName());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    static LogRecord getClusterList(Logger logger) {
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_INSTALLED_CLUSTERS");
        logRecord.setParameters(EnabledModulesCollector.getClusterNames().toArray());
        logRecord.setLoggerName(logger.getName());
        return logRecord;
    }

    static LogRecord getUserInstalledModules(Logger logger) {
        LogRecord logRecord = new LogRecord(Level.INFO, "USG_USER_INSTALLED_MODULES");
        HashSet<String> hashSet = new HashSet<String>(EnabledModulesCollector.getClusterNames());
        hashSet.add("platform");
        ArrayList<ModuleInfo> arrayList = new ArrayList<ModuleInfo>();
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
            String string;
            File file;
            File file2;
            Object object = moduleInfo.getAttribute("AutoUpdate-Show-In-Client");
            if (!(object instanceof String) || !Boolean.parseBoolean((String)object) || (file2 = EnabledModulesCollector.getModuleJarFile(moduleInfo)) == null || !(file = file2.getParentFile()).getName().equals("modules") || hashSet.contains(string = file.getParentFile().getName())) continue;
            arrayList.add(moduleInfo);
        }
        logRecord.setParameters(EnabledModulesCollector.getModuleNames(arrayList));
        logRecord.setLoggerName(logger.getName());
        return logRecord;
    }

    private static File getModuleJarFile(ModuleInfo moduleInfo) {
        try {
            Method method = moduleInfo.getClass().getMethod("getJarFile", new Class[0]);
            method.setAccessible(true);
            return (File)method.invoke((Object)moduleInfo, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

