/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.designelement;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.design.LayoutItemType;
import com.jrockit.mc.components.ui.design.designelement.AbstractElement;
import com.jrockit.mc.components.ui.design.designelement.IDesignElement;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.layout.SimpleLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.FormColors;

final class ComponentElement
extends AbstractElement {
    private static final int DEFAULT_MARGIN_SPACING = 6;

    ComponentElement() {
    }

    public void paint(PaintEvent e) {
        Display display = e.display;
        GC gc = e.gc;
        this.fillBackground(UIPlugin.getDefault().getFormColors(display), gc);
        this.setGcColors(gc);
        Rectangle client = this.createInset(this.getControl().getClientArea(), 10);
        gc.fillRectangle(client);
        gc.drawRectangle(client);
        if (this.getControl().getChildren().length == 0) {
            this.drawInfo(e.gc);
        }
    }

    private void fillBackground(FormColors colors, GC gc) {
        gc.setBackground(colors.getBackground());
        gc.setForeground(colors.getForeground());
        gc.fillRectangle(this.getControl().getClientArea());
    }

    private void setGcColors(GC gc) {
        if (this.isSelectedOrParent(this)) {
            gc.setBackground(this.getControl().getDisplay().getSystemColor(26));
            gc.setForeground(this.getControl().getDisplay().getSystemColor(25));
        } else {
            if (this.getControl().getChildren().length == 0) {
                gc.setBackground(this.getControl().getDisplay().getSystemColor(22));
            } else {
                gc.setBackground(this.getControl().getDisplay().getSystemColor(25));
            }
            gc.setForeground(this.getControl().getDisplay().getSystemColor(21));
        }
    }

    private boolean isSelectedOrParent(IDesignElement element) {
        if (this.isSelected()) {
            return true;
        }
        return element.getParentElement() == null ? false : this.isSelectedOrParent(element.getParentElement());
    }

    private void drawInfo(GC gc) {
        this.drawText(gc, 0, this.formatLayoutProperties());
        ComponentDescriptor cd = this.getLayoutItem().getComponentDescriptor();
        this.drawText(gc, 2, "Name: " + (cd == null ? Messages.LAYOUT_ITEM_MISSING_COMPONENT_DESCRIPTOR_TEXT : cd.getName()));
        this.drawText(gc, 3, "Type: " + this.getTypeDescription());
        this.drawText(gc, 4, "Identifier: " + (cd == null ? Messages.LAYOUT_ITEM_MISSING_COMPONENT_DESCRIPTOR_TEXT : cd.getIdentifier()));
        if (cd != null) {
            this.drawIcon(gc, cd);
        }
    }

    private String getTypeDescription() {
        ComponentDescriptor cd = this.getLayoutItem().getComponentDescriptor();
        if (cd != null) {
            return cd.getTypeIdentifier();
        }
        LayoutItemType type = this.getLayoutItem().getType();
        if (type != null) {
            return type.getName();
        }
        return Messages.LAYOUT_ITEM_MISSING_COMPONENT_DESCRIPTOR_TEXT;
    }

    private void drawIcon(GC gc, ComponentDescriptor cd) {
        ComponentTypeDescriptor ct = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptor(cd.getTypeIdentifier());
        if (ct != null && ct.getIcon() != null) {
            int width = this.getControl().getClientArea().width;
            int height = this.getControl().getClientArea().height;
            gc.drawImage(ct.getIcon(), 0, 0, 16, 16, width / 2 - 8, height / 2 - 8, 16, 16);
        }
    }

    private String formatLayoutProperties() {
        String result = "";
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_MINIMUM_LAYOUT_SIZE_TEXT + this.formatLayoutSize(this.getLayoutItem().getLayoutData().getMinimumSize()) + ' ';
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_MAXIMUM_LAYOUT_SIZE_TEXT + this.formatLayoutSize(this.getLayoutItem().getLayoutData().getMaximumSize()) + ' ';
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_LAYOUT_WEIGHT_TEXT + this.getLayoutItem().getLayoutData().getWeight() + ' ';
        result = String.valueOf(result) + Messages.LAYOUT_ITEM_SIZE + this.getControl().getClientArea().width + 'x' + this.getControl().getClientArea().height;
        return result;
    }

    private String formatLayoutSize(int size) {
        switch (size) {
            case 0x7FFFFFFF: {
                return "Infinity";
            }
            case -2147483648: {
                return "Preferred size";
            }
        }
        return Integer.toString(size);
    }

    private void drawText(GC gc, int row, String text) {
        int centerX = 5;
        int centerY = 5;
        gc.drawString(text, centerX, centerY + row * (gc.getFontMetrics().getHeight() + 5));
    }

    private Rectangle createInset(Rectangle rect, int inset) {
        Rectangle rectangle = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        --rectangle.width;
        --rectangle.height;
        return rectangle;
    }

    @Override
    protected Composite createControl(Composite parent) {
        Canvas canvas = new Canvas(parent, 0x20040000);
        canvas.setLayout(this.createLayout());
        this.hookPaintListener(canvas);
        return canvas;
    }

    private Layout createLayout() {
        SimpleLayout layout = new SimpleLayout();
        layout.setMargin(0);
        layout.setHorizontalOrientation(this.getType().getHorizontal());
        layout.setSpacing(this.getType().getPadding() ? 6 : 0);
        return layout;
    }

    private LayoutItemType getType() {
        return this.getLayoutItem().getType();
    }

    private void hookPaintListener(Canvas canvas) {
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ComponentElement.this.paint(e);
            }
        });
    }
}

