/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.editor;

import com.jrockit.mc.common.Callback;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.components.ui.design.DesignEditor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.ConsoleEditorInput;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.ui.internal.SectionPartManager;
import com.jrockit.mc.rjmx.ui.misc.JVMSupportUIToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.TemporaryMessage;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;

public class ConsoleEditor
extends DesignEditor {
    private final List<SectionPartManager> m_sectionPartManagers = new ArrayList<SectionPartManager>();
    private volatile boolean m_isClosed = false;
    private volatile IConnectionHandle connection;

    public ConsoleEditor() {
        this.setNavigatorPosition("left");
        this.setTabPosition("bottom");
    }

    public List<SectionPartManager> getSectionPartManagers() {
        return this.m_sectionPartManagers;
    }

    public ConsoleEditorInput getEditorInput() {
        return (ConsoleEditorInput)super.getEditorInput();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        super.dispose();
        this.m_isClosed = true;
        IOToolkit.closeSilently((Closeable)this.connection);
    }

    protected Job initialize(IServiceLocator locator) throws PartInitException {
        return new ConnectJob();
    }

    protected void initializeEditor(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ConsoleEditorInput)) {
            ConsolePlugin.getDefault().getLogger().log(Level.WARNING, "Got weird input to editor: " + input);
            throw new PartInitException("Invalid Input: Must be ConsoleEditorInput");
        }
        this.setPartName(input.getName());
    }

    public int promptToSaveOnClose() {
        return 0;
    }

    public IConnectionHandle getConnectionHandle() {
        return this.connection;
    }

    public void addSectionManager(SectionPartManager spm) {
        this.m_sectionPartManagers.add(spm);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IConnectionHandle.class && this.connection != null) {
            return this.connection;
        }
        return super.getAdapter(adapter);
    }

    private final class ConnectJob
    extends Job {
        private ConnectJob() {
            super(Messages.ConsoleEditor_OPENING_MANAGEMNT_CONSOLE);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ConsoleEditor.this.connection = ConsoleEditor.this.getEditorInput().getServerHandle().connect(Messages.ConsoleEditor_MANAGEMNT_CONSOLE, (Callback)new ConnectionListener());
                ConsoleEditor.this.getServiceLocator().registerService(IConnectionHandle.class.getName(), (Object)ConsoleEditor.this.connection);
                if (!JVMSupportUIToolkit.checkConsoleSupport((IConnectionHandle)ConsoleEditor.this.connection, (Control)ConsoleEditor.this.getContainer())) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
            catch (ConnectionException e) {
                return new Status(4, "com.jrockit.mc.console.ui", 4, NLS.bind((String)Messages.ConsoleEditor_COULD_NOT_CONNECT, (Object)ConsoleEditor.this.getEditorInput().getName(), (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    private final class ConnectionListener
    implements Callback<IConnectionHandle> {
        private ConnectionListener() {
        }

        public void call(IConnectionHandle connection) {
            boolean serverDisposed;
            boolean bl = serverDisposed = ConsoleEditor.this.getEditorInput().getServerHandle().getState() == IServerHandle.State.DISPOSED;
            if (!ConsoleEditor.this.m_isClosed) {
                if (serverDisposed) {
                    DisplayToolkit.safeAsyncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ConsoleEditor.this.getSite().getPage().closeEditor((IEditorPart)ConsoleEditor.this, false);
                        }
                    });
                } else if (!connection.isConnected()) {
                    DisplayToolkit.safeAsyncExec((Display)ConsoleEditor.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            int count = ConsoleEditor.this.pages.size();
                            int i = 0;
                            while (i < count) {
                                IFormPage page = (IFormPage)ConsoleEditor.this.pages.get(i);
                                IMessageManager manager = (IMessageManager)page.getAdapter(IMessageManager.class);
                                if (manager != null) {
                                    TemporaryMessage message = new TemporaryMessage(Messages.ConsoleEditor_CONNECTION_LOST, 3);
                                    message.setDelay(Integer.MAX_VALUE);
                                    message.show(manager, ConsoleEditor.this.getSite().getShell().getDisplay());
                                }
                                ++i;
                            }
                        }
                    });
                }
            }
        }
    }
}

