/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.UnitLookup;

public final class UnitDescriptor {
    public static final String CONTENT_TYPE = "contentType";
    public static final String DISPLAY_UNIT = "displayUnit";
    public static final String NAME = "unit";
    public static final String DERIVATIVE = "derivative";
    private final Setting m_setting = new Setting("unit");

    static {
        PersistenceToolkit.registerFetcher(UnitDescriptor.class, new ISettingFetcher<UnitDescriptor>(){

            @Override
            public Setting getSetting(UnitDescriptor unit) {
                return unit.m_setting;
            }
        });
    }

    public UnitDescriptor() {
        this.setDisplayUnit(UnitLookup.UNKNOWN.getDisplayUnit("auto"));
    }

    public void setDisplayUnit(DisplayUnit<?> displayUnit) {
        ContentType<?> type = displayUnit.getContentType();
        this.m_setting.setChildObject(CONTENT_TYPE, type.getIdentifier());
        this.m_setting.setChildObject(DISPLAY_UNIT, displayUnit.getIdentifier());
    }

    public IUnit<?> getUnit() {
        ContentType<?> type = UnitLookup.getContentType(this.m_setting.getChildObject(CONTENT_TYPE, String.class));
        if (type instanceof LinearKindOfQuantity) {
            LinearUnit legacyUnit = ((LinearKindOfQuantity)type).getLegacyImplicitUnit();
            return legacyUnit;
        }
        return UnitLookup.getUnitOrDefault(this.m_setting.getChildObject(DISPLAY_UNIT, String.class));
    }

    public DisplayUnit<?> getDisplayUnit() {
        ContentType<?> type = UnitLookup.getContentType(this.m_setting.getChildObject(CONTENT_TYPE, String.class));
        return type.getDisplayUnit(this.m_setting.getChildObject(DISPLAY_UNIT, String.class));
    }

    public void setProperty(String key, String value) {
        this.m_setting.setChildObject(key, value);
    }

    public String getProperty(String key, String value) {
        return this.m_setting.getChildObject(key, String.class);
    }

    public boolean getDerivative() {
        return this.m_setting.getChildObject(DERIVATIVE, Boolean.class);
    }

    public void setDerivative(boolean useDerivative) {
        this.m_setting.setChildObject(DERIVATIVE, useDerivative);
    }
}

