/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.jface.dialogs.IDialogSettings;

public class FieldToolkit {
    private static final String EXTENSION = ".properties";
    private static volatile String[] nlSuffixes;
    public static final String DIALOGSETTINGS_VALUE = "thevalue";

    public static int getIDfromName(String name) throws NumberFormatException {
        return Integer.parseInt(name);
    }

    public static String getNameFromID(int id) {
        return Integer.toString(id);
    }

    public static com.jrockit.mc.ui.model.fields.Field getFieldFromIdentifier(String identifier, com.jrockit.mc.ui.model.fields.Field[] fields) {
        try {
            com.jrockit.mc.ui.model.fields.Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                com.jrockit.mc.ui.model.fields.Field field = fieldArray[n2];
                if (field.IDENTIFIER.equals(identifier)) {
                    return field;
                }
                ++n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static void fillDialogSettingsFromFields(com.jrockit.mc.ui.model.fields.Field[] fields, IDialogSettings settings) {
        com.jrockit.mc.ui.model.fields.Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            com.jrockit.mc.ui.model.fields.Field field = fieldArray[n2];
            try {
                String name = field.IDENTIFIER;
                IDialogSettings fieldSetting = settings.getSection(name);
                if (fieldSetting == null) {
                    fieldSetting = settings.addNewSection(name);
                }
                Properties props = field.getProperties();
                for (String string : props.keySet()) {
                    String value = props.getProperty(string);
                    String strippedKey = field.getKeyFromProperty(string);
                    if (strippedKey == null || strippedKey.equals("NAME_TEXT") || strippedKey.equals("DESCRIPTION_TEXT")) continue;
                    FieldToolkit.storeSetting(fieldSetting, strippedKey, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    public static void fillFieldsFromDialogSettings(IDialogSettings settings, com.jrockit.mc.ui.model.fields.Field[] fields) {
        IDialogSettings[] fieldSettings;
        IDialogSettings[] iDialogSettingsArray = fieldSettings = settings.getSections();
        int n = fieldSettings.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogSettings fieldSetting = iDialogSettingsArray[n2];
            try {
                com.jrockit.mc.ui.model.fields.Field field = FieldToolkit.getFieldFromIdentifier(fieldSetting.getName(), fields);
                if (field != null) {
                    IDialogSettings[] properties;
                    IDialogSettings[] iDialogSettingsArray2 = properties = fieldSetting.getSections();
                    int n3 = properties.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IDialogSettings propertie = iDialogSettingsArray2[n4];
                        String key = propertie.getName();
                        String value = propertie.get(DIALOGSETTINGS_VALUE);
                        if (value != null && key != null) {
                            field.setProperty(key, value);
                        }
                        ++n4;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private static void storeSetting(IDialogSettings fieldSetting, String key, Object value) {
        IDialogSettings fieldProperty = fieldSetting.getSection(key);
        if (fieldProperty == null) {
            fieldProperty = fieldSetting.addNewSection(key);
        }
        fieldProperty.put(DIALOGSETTINGS_VALUE, value.toString());
    }

    public static com.jrockit.mc.ui.model.fields.Field[] instantiateFieldArray(com.jrockit.mc.ui.model.fields.Field[] fieldPrototypes) {
        com.jrockit.mc.ui.model.fields.Field[] fields = new com.jrockit.mc.ui.model.fields.Field[]{};
        if (fieldPrototypes != null) {
            fields = new com.jrockit.mc.ui.model.fields.Field[fieldPrototypes.length];
            int n = 0;
            while (n < fieldPrototypes.length) {
                fields[n] = fieldPrototypes[n].newInstance();
                ++n;
            }
        }
        return fields;
    }

    public static com.jrockit.mc.ui.model.fields.Field[] getFields(Class<?> clazz) {
        Field[] fieldArray;
        ArrayList<com.jrockit.mc.ui.model.fields.Field> list = new ArrayList<com.jrockit.mc.ui.model.fields.Field>();
        Field[] fieldArray2 = fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field element = fieldArray2[n2];
            try {
                Object object;
                if ((element.getModifiers() & 8) != 0 && (object = element.get(null)) instanceof com.jrockit.mc.ui.model.fields.Field) {
                    com.jrockit.mc.ui.model.fields.Field fieldObject = (com.jrockit.mc.ui.model.fields.Field)object;
                    fieldObject.initialize(String.valueOf(clazz.getSimpleName()) + "_" + element.getName());
                    list.add(fieldObject);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++n2;
        }
        try {
            return list.toArray(new com.jrockit.mc.ui.model.fields.Field[list.size()]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void initializeFields(Class<?> clazz) {
        String name = clazz.getName();
        int lastPackageDot = name.lastIndexOf(46);
        FieldToolkit.initializeFields(String.valueOf(name.substring(0, lastPackageDot)) + ".fields", clazz);
    }

    public static void initializeFields(String bundleName, Class<?> clazz) {
        com.jrockit.mc.ui.model.fields.Field[] fields = FieldToolkit.getFields(clazz);
        Properties properties = new Properties();
        String[] variants = FieldToolkit.buildVariants(bundleName);
        ClassLoader loader = clazz.getClassLoader();
        int i = 0;
        while (i < variants.length) {
            block17: {
                InputStream input = loader.getResourceAsStream(variants[variants.length - 1 - i]);
                if (input != null) {
                    try {
                        try {
                            properties.load(input);
                            com.jrockit.mc.ui.model.fields.Field[] fieldArray = fields;
                            int n = fields.length;
                            int n2 = 0;
                            while (n2 < n) {
                                com.jrockit.mc.ui.model.fields.Field field = fieldArray[n2];
                                field.setProperties(properties);
                                ++n2;
                            }
                        }
                        catch (IOException e) {
                            System.err.println("Error loading " + variants[i]);
                            System.err.println(e);
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static String[] buildVariants(String root) {
        if (nlSuffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            nlSuffixes = result.toArray(new String[result.size()]);
        }
        root = root.replace('.', '/');
        String[] variants = new String[nlSuffixes.length];
        int i = 0;
        while (i < variants.length) {
            variants[i] = String.valueOf(root) + nlSuffixes[i];
            ++i;
        }
        return variants;
    }

    public static boolean containsField(Class<?> clazz, com.jrockit.mc.ui.model.fields.Field[] fields, boolean onlyVisible) {
        com.jrockit.mc.ui.model.fields.Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            com.jrockit.mc.ui.model.fields.Field field = fieldArray[n2];
            if ((!onlyVisible || field.isVisible()) && clazz.isInstance(field)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

