/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import java.util.Comparator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FieldViewerComparator
extends ViewerComparator
implements Listener {
    private static final String IS_LAST_SORT_ORDER_ASCENDING = "VIEWER_SORT_ORDER_ASCENDING";
    public static final String SET_SORT_ORDER_ASCENDING = "SET_SORT_ORDER_ASCENDING";
    public static final String SET_SORT_ORDER_DESCENDING = "SET_SORT_ORDER_DESCENDING";
    private final Field m_field;
    private final int m_rowIndex;
    private final StructuredViewer m_viewer;
    private final Comparator<Object> m_comparator = new FieldComparator();
    protected boolean m_sortOrderAscending;

    public FieldViewerComparator(StructuredViewer viewer, Field field) {
        this(viewer, field, field.getSortOrderAscending());
    }

    public FieldViewerComparator(StructuredViewer viewer, Field field, boolean sortorderAscending) {
        this.m_viewer = viewer;
        this.m_field = field;
        this.m_rowIndex = field.INDEX;
        this.setSortOrderAscending(sortorderAscending);
    }

    public void handleEvent(Event event) {
        this.setSortOrderAscending(!this.getSortOrderAscendng());
        this.m_viewer.setComparator((ViewerComparator)this);
    }

    private void setSortOrderAscending(boolean b) {
        this.m_sortOrderAscending = b;
        this.m_field.setBoolean(IS_LAST_SORT_ORDER_ASCENDING, b);
    }

    public final int compare(Viewer viewer, Object e1, Object e2) {
        return this.m_comparator.compare(e1, e2);
    }

    public final Field getField() {
        return this.m_field;
    }

    public Comparator<Object> getComparator() {
        return this.m_comparator;
    }

    public final boolean getSortOrderAscendng() {
        return this.m_field.getBoolean(IS_LAST_SORT_ORDER_ASCENDING, false);
    }

    private final class FieldComparator
    implements Comparator<Object> {
        private FieldComparator() {
        }

        @Override
        public final int compare(Object argA, Object argB) {
            if (argA instanceof Row && argB instanceof Row) {
                Object a = ((Row)argA).COLUMNS[FieldViewerComparator.this.m_rowIndex];
                Object b = ((Row)argB).COLUMNS[FieldViewerComparator.this.m_rowIndex];
                if (a == null || b == null) {
                    this.getInvalidObjectsOrder(a != null, b != null);
                }
                return FieldViewerComparator.this.m_field.compare(a, b, FieldViewerComparator.this.m_sortOrderAscending);
            }
            UIPlugin.getDefault().getLogger().warning("FieldViewerComparator should only sort Row objects. Got: " + argA + ", " + argB);
            return this.getInvalidObjectsOrder(argA instanceof Row, argB instanceof Row);
        }

        private int getInvalidObjectsOrder(boolean aValid, boolean bValid) {
            int order;
            int n = order = FieldViewerComparator.this.m_sortOrderAscending ? -1 : 1;
            return aValid ? order : (bValid ? -order : 0);
        }
    }
}

